<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

add_action( 'tgmpa_register', 'camille_register_required_plugins' );

if(!function_exists('camille_register_required_plugins')){

	function camille_register_required_plugins() {

		$plugins = array();

		$plugins[] = array(
			'name'					=> esc_html_x('WPBakery Visual Composer', 'admin-view', 'camille'),
			'slug'					=> 'js_composer',
			'source'				=> get_template_directory() . '/plugins/js_composer.zip',
			'required'				=> true,
			'version'				=> '5.4.7'
		);

		$plugins[] = array(
			'name'					=> esc_html_x('LA-Studio Core', 'admin-view', 'camille'),
			'slug'					=> 'lastudio',
			'source'				=> get_template_directory() . '/plugins/lastudio.zip',
			'required'				=> true,
			'version'				=> '1.0.0'
		);

		$plugins[] = array(
			'name'					=> esc_html_x('Camille Package Demo Data', 'admin-view', 'camille'),
			'slug'					=> 'camille-demo-data',
			'source'				=> get_template_directory() . '/plugins/camille-demo-data.zip',
			'required'				=> true,
			'version'				=> '1.0.0'
		);

		$plugins[] = array(
			'name'     				=> esc_html_x('WooCommerce', 'admin-view', 'camille'),
			'slug'     				=> 'woocommerce',
			'version'				=> '3.3.5',
			'required' 				=> false
		);

		$plugins[] = array(
			'name'					=> esc_html_x('Slider Revolution', 'admin-view', 'camille'),
			'slug'					=> 'revslider',
			'source'				=> get_template_directory() . '/plugins/revslider.zip',
			'required'				=> false,
			'version'				=> '5.4.7.3'
		);

		$plugins[] = array(
			'name' 					=> esc_html_x('Contact Form 7', 'admin-view', 'camille'),
			'slug' 					=> 'contact-form-7',
			'required' 				=> false
		);

		$plugins[] = array(
			'name'					=> esc_html_x('LaStudio Discography', 'admin-view', 'camille'),
			'slug'					=> 'lastudio-discography',
			'source'				=> get_template_directory() . '/plugins/lastudio-discography.zip',
			'required'				=> false,
			'version'				=> '1.0.0'
		);

		$plugins[] = array(
			'name'					=> esc_html_x('LaStudio Events', 'admin-view', 'camille'),
			'slug'					=> 'lastudio-events',
			'source'				=> get_template_directory() . '/plugins/lastudio-events.zip',
			'required'				=> false,
			'version'				=> '1.0.0'
		);

		$plugins[] = array(
			'name'					=> esc_html_x('LaStudio Playlist', 'admin-view', 'camille'),
			'slug'					=> 'lastudio-playlist-manager',
			'source'				=> get_template_directory() . '/plugins/lastudio-playlist-manager.zip',
			'required'				=> false,
			'version'				=> '1.0.0'
		);
		$plugins[] = array(
			'name'					=> esc_html_x('LaStudio Video', 'admin-view', 'camille'),
			'slug'					=> 'lastudio-videos',
			'source'				=> get_template_directory() . '/plugins/lastudio-videos.zip',
			'required'				=> false,
			'version'				=> '1.0.0'
		);

		$config = array(
			'id'           				=> 'camille',
			'default_path' 				=> '',
			'menu'         				=> 'tgmpa-install-plugins',
			'has_notices'  				=> true,
			'dismissable'  				=> true,
			'dismiss_msg'  				=> '',
			'is_automatic' 				=> false,
			'message'      				=> ''
		);

		tgmpa( $plugins, $config );

	}

}
